<?php

namespace App\Http\Controllers;
use App\Cliente;
use App\OrdemCliente;
use App\Http\Services\ClienteService;
use Illuminate\Http\Request;

class ClienteController extends Controller{

    protected $service;

    public function __construct(ClienteService $service) {
        $this->service = $service;
    }

    public function index() {
        $lista = Cliente::all();
        return view('adm.clientes.index', ['section' => 'clientes','lista' => $lista]);
    }

    public function create() {
        return view('adm.clientes.create',['section' => 'clientes']);
    }

    public function show(Cliente $cliente) {
        return view('adm.clientes.show', ['section' => 'clientes','cliente' => $cliente]);
    }

    public function store(Request $request) {
        $this->service->store($request);
        return redirect()->route('clientes.index');
    }

    public function edit(Cliente $cliente) {
        return view('adm.clientes.edit',['section' => 'clientes','cliente' => $cliente]);
    }
    
    public function update(Request $request, Cliente $cliente) {
        $this->service->update($request, $cliente);
        return redirect()->route('clientes.index');
    }

    public function destroy(Cliente $cliente) {
        $cliente->imagens()->delete();
        $cliente->delete();
        return redirect()->route('clientes.index');
    }

    public function ordem(){
        $valores = $this->service->ordem();
        return view('adm.clientes.ordem',['section' => 'clientes', 'valores' => $valores]);
    }

    public function salvarOrdem(Request $request){
        $valores = $request->except('_token','_method');
        $ordem   = OrdemCliente::find(1)->fill(['ordem' => json_encode($valores)])->save();
        return redirect()->route('clientes.index');
    }
}
