<?php

namespace App\Http\Controllers;
use App\Http\Services\ClienteService;
use App\Contato;
use Illuminate\Http\Request;

class EmailController extends Controller
{
    public function index(Request $request){

        $request->validate(
        [
            'nome'  => 'required',
            'email' => 'required|email',
            'mensagem' => 'required'            
        ]);

        $dados = $request->all();
        $contato = Contato::find(1);

        \Mail::Send('site.email', $dados, function($message) use ($dados, $contato){
            $message->from('contatosite@biovitae.com.br');
            $message->to($contato->getAttribute('email'));
            $subject = ( array_key_exists ( 'assunto' , $dados ) ) ? $dados['assunto'] : $contato->getAttribute('assunto');
            $message->subject($subject);
        });

        return redirect()->route('site', ['section' => 'contato']);
    }
}