<?php

namespace App\Http\Controllers;
use App\User;
use Illuminate\Http\Request;


class UsuarioController extends Controller{

    public function index() {
        $lista = User::all();
        return view('adm.user.index', ['section' => 'user','lista' => $lista]);
    }

    public function store(Request $request) {
        $dados = $request->all();
        $dados['password'] = bcrypt($dados['password']);
        $user = User::create($dados);
        return redirect()->route('user.index');
    }

    public function edit($user_id) {
        $user = User::find($user_id);
        return view('adm.user.edit',['section' => 'user','user' => $user]);
    }

    public function update(Request $request, $user_id) {

        $user = User::find($user_id);
        $dados = $request->all();   
        $dados['password'] = bcrypt($dados['password']);
        $user->fill($dados)->save();
        return redirect()->route('user.index');
    }

    public function destroy(User $user) {
        $user->delete();
        return redirect()->route('user.index');
    }
}
    

