
@extends('adm.template.template')

@section('conteudo')

    <a class="btn btn-primary" href="{{ route('clientes.create') }}">
        Novo Cliente <span class="fa fa-plus"></span>
    </a>
    <a class="btn btn-default" href="{{ route('clientes.ordem') }}">
        Ordenar Clientes <span class="fa fa-list"></span>
    </a>
    <div class="table-responsive">
        <table class="table table-bordered" id="listagem">
            <thead>
                <tr style="background-color: #f9f9f9">
                    <td>Nome</td>
                    <td>Descrição</td>
                    <td class="text-center" style="width: 5%;">Ver</td>
                    <td class="text-center" style="width: 5%;">Editar</td>
                    <td class="text-center" style="width: 5%;">Excluir</td>
                </tr>
            </thead>
            <tbody>
            @foreach($lista as $cliente)
                <tr>
                    <td>{{ $cliente->nome }}</td>
                    <td>{{ $cliente->descricao }}</td>
                    <td class="text-center">
                        <a href="{{ route('clientes.show', $cliente->id) }}">
                            <span class="fa fa-eye"></span>
                        </a>
                    </td>
                    <td class="text-center">
                        <a href="{{ route('clientes.edit', $cliente->id) }}">
                            <span class="fa fa-pencil"></span>
                        </a>
                    </td>
                    <td class="text-center">
                        {!! Form::open(['route' => ['clientes.destroy', $cliente->id], 'method' => 'DELETE']) !!}
                            {{ Form::button('<span class="fa fa-trash"></span>', 
                                ['type' => 'submit', 'style' => 'color:red', ] )  
                            }}                        
                        {!! Form::close() !!}
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

@endsection

@section('js')
    <script type="text/javascript" src="{{ asset('js/adm/clientes.js') }}"></script>
@endsection