
@extends('adm.template.template')

@section('conteudo')

    <div class="table-responsive">
        <table class="table table-bordered" id="listagem">
            <tbody>
                <tr>
                    <td style="width: 15%">Nome</td>
                    <td>{{ $cliente->nome }}</td>
                </tr>
                <tr>
                    <td style="width: 15%">Descrição</td>
                    <td>{{ $cliente->descricao }}</td>
                </tr>
                <tr>
                    <td style="width: 15%">Data de Criação</td>
                    <td>{{ date_create_from_format('Y-m-d H:i:s', $cliente->created_at)->format('d/m/Y') }}</td>
                </tr>
                <tr>
                    <td style="width: 15%">Última Atualização</td>
                    <td>{{ date_create_from_format('Y-m-d H:i:s', $cliente->created_at)->format('d/m/Y à\s H:i:s') }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div id="showImagem" class="modal fade" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Imagem</h4>
                </div>
                <div class="modal-body">
                    <img id="imagem-full" style="width: 100%" src="#" />
                </div>
            </div>

        </div>
    </div>

    @foreach($cliente->imagens as $imagem)
        <img src="{{ asset($imagem->path) }}" 
            style="width: 100px; height: 100px; margin: 5px; cursor: pointer"
            class="img-thumbnail imagem"/>
    @endforeach

@endsection

@section('js')
    <script type="text/javascript" src="{{ asset('js/adm/clientes.js') }}"></script>
@endsection