
@extends('adm.template.template')

@section('conteudo')

    <div class="table-responsive">
        <table class="table table-bordered" id="listagem">
            <thead>
                <tr style="background-color: #f9f9f9">
                    <td>Serial</td>
                    <td>Evento</td>
                    <td>Setor</td>
                    <td>Classificação do Ingresso</td>
                    <td>Tipo do Ingresso</td>
                    <td>Ocorrência</td>
                    <td>Data e Horário</td>
                </tr>
            </thead>
            <tbody>
            @foreach($lista as $log)
                <tr>
                    <td>{{ $log->serial }}</td>
                    <td>{{ $log->evento->nome }}</td>
                    <td>{{ $log->setor }}</td>
                    <td>{{ $log->classificacao_ingresso }}</td>
                    <td>{{ $log->tipo_ingresso }}</td>
                    <td>{{ $log->ocorrencia }}</td>
                    <td>
                        {{ date_create_from_format('Y-m-d H:i:s', $log->data_horario)->format('d/m/Y H:i:s') }} 
                    </td> 
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    
@endsection

@section('js')
    <script type="text/javascript" src="{{ asset('js/adm/log_acessos.js') }}"></script>
@endsection