<!DOCTYPE html>

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>TenTickets</title>

        <link href="{{ asset('http://fonts.googleapis.com/css?family=Open+Sans:400,300,400italic,600,700') }}" rel='stylesheet' type='text/css'>
        <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">
        <link href="{{ asset('css/datatables-boostrap.min.css') }}" rel="stylesheet">
        <link href="{{ asset('css/font-awesome.min.css') }}" rel="stylesheet">
        <link href="{{ asset('css/templatemo-style.css') }}" rel="stylesheet">
    </head>

    <body>
        @guest
            <div class="row">
                <div class="col-md-12">
                    <section class="container tm-home-section-1 col-md-offset-4" id="more" style="margin-top: 10%;">
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-6">
                                <!-- Nav tabs -->
                                <div class="tm-home-box-1">
                                    <ul class="nav nav-tabs" id="hotelCarTabs">
                                        <li style="width: 100%;">
                                            <a>Acesso Restrito</a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div role="tabpanel" class="tab-pane fade in active tm-white-bg" id="hotel">
                                            <div class="tm-search-box effect2">
                                                <form method="POST" action="{{ route('login') }}" class="hotel-search-form">
                                                    @csrf

                                                    <div class="tm-form-inner">
                                                        <div class="form-group">
                                                                <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required autofocus>

                                                                @if ($errors->has('email'))
                                                                    <label class="error" role="alert">
                                                                        <strong>{{ $errors->first('email') }}</strong>
                                                                    </label>
                                                                @endif
                                                        </div>

                                                        <div class="form-group">
                                                                <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>

                                                                @if ($errors->has('password'))
                                                                    <label class="error" role="alert">
                                                                        <strong>{{ $errors->first('password') }}</strong>
                                                                    </label>
                                                                @endif
                                                        </div>
                                                    </div>

                                                    <div class="form-group tm-yellow-gradient-bg text-center">
                                                        <button type="submit"  class="tm-yellow-btn">
                                                            {{ __('Login') }}
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>			    
                                    </div>
                                </div>								
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        @else
            <div class="row">
                <div class="col-md-12">
                    <section class="container tm-home-section-1 col-md-offset-4" id="more" style="margin-top: 10%;">
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-6">
                                <div class="tm-home-box-1">
                                    <ul class="nav nav-tabs" id="hotelCarTabs">
                                        <li style="width: 100%;">
                                            <a>Logout</a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div role="tabpanel" class="tab-pane fade in active tm-white-bg" id="hotel">
                                            <div class="tm-search-box effect2 text-center"> 
                                                Você já esta logado. Clique
                                                <a href="{{ route('logout') }}"
                                                    onclick="event.preventDefault();
                                                                    document.getElementById('logout-form').submit();">
                                                    Aqui
                                                </a>
                                                para deslogar!

                                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                                    @csrf
                                                </form>
                                            </div>								
                                        </div>
                                    </div>     
                                </div>								
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        @endguest
        <script src="{{ asset('js/app.js') }}" defer></script>

    </body>

</html>