<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

//Site - Frontend
Route::get('/', 'SiteController@index')->name('home');
Route::post('/email', 'EmailController@index')->name('email');
Route::get('/{section?}', 'SiteController@index')->name('site');

//Adm - Backend
Route::group(['prefix' => 'adm',  'middleware' => 'auth'], function() {
    Route::resource('/user', 'UsuarioController');
    Route::resource('/conteudos', 'ConteudoController');
    Route::get('/clientes/ordem', 'ClienteController@ordem')->name('clientes.ordem');
    Route::put('/clientes/ordem', 'ClienteController@salvarOrdem')->name('clientes.salvarOrdem');
    Route::resource('/clientes', 'ClienteController');
    Route::resource('/contato', 'ContatoController');
    Route::get('/log_acessos', 'LogAcessosController@listar')->name('log_acessos.listar');
});

