<?php /* /var/www/html/tentickets.com.br/web/tentickets/resources/views/adm/clientes/index.blade.php */ ?>
<?php $__env->startSection('conteudo'); ?>

    <a class="btn btn-primary" href="<?php echo e(route('clientes.create')); ?>">
        Novo Cliente <span class="fa fa-plus"></span>
    </a>
    <a class="btn btn-default" href="<?php echo e(route('clientes.ordem')); ?>">
        Ordenar Clientes <span class="fa fa-list"></span>
    </a>
    <div class="table-responsive">
        <table class="table table-bordered" id="listagem">
            <thead>
                <tr style="background-color: #f9f9f9">
                    <td>Nome</td>
                    <td>Descrição</td>
                    <td class="text-center" style="width: 5%;">Ver</td>
                    <td class="text-center" style="width: 5%;">Editar</td>
                    <td class="text-center" style="width: 5%;">Excluir</td>
                </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $lista; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($cliente->nome); ?></td>
                    <td><?php echo e($cliente->descricao); ?></td>
                    <td class="text-center">
                        <a href="<?php echo e(route('clientes.show', $cliente->id)); ?>">
                            <span class="fa fa-eye"></span>
                        </a>
                    </td>
                    <td class="text-center">
                        <a href="<?php echo e(route('clientes.edit', $cliente->id)); ?>">
                            <span class="fa fa-pencil"></span>
                        </a>
                    </td>
                    <td class="text-center">
                        <?php echo Form::open(['route' => ['clientes.destroy', $cliente->id], 'method' => 'DELETE']); ?>

                            <?php echo e(Form::button('<span class="fa fa-trash"></span>', 
                                ['type' => 'submit', 'style' => 'color:red', ] )); ?>                        
                        <?php echo Form::close(); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/adm/clientes.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adm.template.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>