<?php /* C:\xampp\htdocs\laravel\blog\resources\views/adm/usuarios/index.blade.php */ ?>
<?php $__env->startSection('conteudo'); ?>

    <div class="table-responsive">
        <table class="table table-bordered" id="listagem">
            <thead>
                <tr style="background-color: #f9f9f9">
                    <td>Login</td>
                    <td>Email</td>
                    <td>Data de Criação</td>
                    <td>Última Atualização</td>
                    <td class="text-center" style="width: 5%;">Editar</td>
                    <td class="text-center" style="width: 5%;">Excluir</td>
                </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $lista; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($user->name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td>
                        <?php echo e(date_create_from_format('Y-m-d H:i:s', $user->created_at)->format('d/m/Y')); ?>

                    </td>
                    <td>
                        <?php echo e(date_create_from_format('Y-m-d H:i:s', $user->updated_at)->format('d/m/Y à\s H:i:s')); ?>

                    </td>
                    <td class="text-center">
                        <a href="<?php echo e(route('usuarios.edit', $user->id)); ?>">
                            <span class="fa fa-pencil"></span>
                        </a>
                    </td>
                    <td class="text-center">
                        <?php if($user->email != 'admin@admin.com'): ?>
                            <?php echo Form::open(['route' => ['usuarios.destroy', $user->id], 'method' => 'DELETE']); ?>

                                <?php echo e(Form::button('<span class="fa fa-trash"></span>', 
                                    ['type' => 'submit', 'style' => 'color:red', ] )); ?>                        
                            <?php echo Form::close(); ?>

                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <?php echo Form::open(['route' => 'usuarios.store', 'method' => 'post', 'id' => 'criar']); ?>

        <label style="margin-top: 30px;">
            <strong>Novo Usuário <span class="fa fa-plus"></span></strong>
        </label>
        <div class="row">
            <div class="form-group col-md-12">
                <?php echo Form::text('name', null, ['placeholder'=>'Nome', 'class' => 'form-control','maxlength' => 15]); ?>

            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-12">
                <?php echo Form::email('email', null,  ['placeholder'=>'Email', 'class' => 'form-control']); ?>

            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-12">
                <?php echo Form::password('password', ['placeholder'=>'Senha', 'class' => 'form-control', 'maxlength' => 8]); ?>

            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-12">
                <?php echo Form::submit('Cadastrar', ['class' => 'btn btn-primary pull-right']); ?>

            </div>
        </div>
    <?php echo Form::close(); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/adm/usuarios.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adm.template.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>